$Title: (5)  Remove value added of land in oap and adjust other agr          

*       ----------------------------------------------------------------       *
*                                                                              *
*                       Global Trade Analysis Project                          *
*                            GTAP Water database                               *
*         (5)  Remove value added of land in oap and adjust other agr          *
*                                                                              *
*       ----------------------------------------------------------------       *

set
targ
targ_pstr target sectors /ctl, rmk, wol/
targ_agr  target sectors /pdri, whti, groi, v_fi, osdi, c_bi, pfbi, ocri,
                          pdrn, whtn, gron, v_fn, osdn, c_bn, pfbn, ocrn,
                          ctl, rmk, wol/
kl factors  /tech_aspros, clerks, service_shop, off_mgr_pros, ag_othlowsk, Capital/
;
alias(kl,lk), (targ,targ_ind)

parameter
  oapadj_pstr adjust ve(land) of oap and allocate to ctl & rmk & wol
  oapadj_agr  adjust ve(land) of oap and allocate to all agr


parameter
  vfm_up
  vfm_dn
  vfmd
  vfa_up
  vfa_dn
  vfad
  OAPver
;
$if "%oapv%" == "oap_NOT" targ(targ_agr)=no;
$if "%oapv%" == "oap_NOT" OAPver = 0;
$if "%oapv%" == "oap_NOT" oapadj_agr  = 0;
$if "%oapv%" == "oap_NOT" oapadj_pstr = 0;


$if "%oapv%" == "oap_agr" targ(targ_agr)=yes;
$if "%oapv%" == "oap_agr" OAPver = 1;
$if "%oapv%" == "oap_agr" oapadj_agr  = 1;
$if "%oapv%" == "oap_agr" oapadj_pstr = 0;


$if "%oapv%" == "oap_pst" targ(targ_pstr)=yes;
$if "%oapv%" == "oap_pst" OAPver = 2;
$if "%oapv%" == "oap_pst" oapadj_agr  = 0;
$if "%oapv%" == "oap_pst" oapadj_pstr = 1;

parameter
  OAPver  "The land value added: %oapv% adjusted"
;

if(oapadj_pstr+oapadj_agr = 1,
    vfm_up(targ,r)     = vfm('land','oap',r)/ sum(targ_ind, vfm('land',targ_ind,r));
    vfmd('land',targ,r)= vfm('land',targ ,r)*(vfm_up(targ,r));
    vfa_up(targ,r)     = evfa('land','oap',r)/sum(targ_ind, evfa('land',targ_ind,r));
    vfad('land',targ,r)= evfa('land',targ ,r)*(vfa_up(targ,r));

    vfm_up('oap',r)    = vfm('land','oap',r)/ sum(lk, vfm(lk,'oap',r));
    vfmd(kl,'oap',r)   = vfm(kl,'oap',r)*vfm_up('oap',r);
    vfa_up('oap',r)    = evfa('land','oap',r)/sum(lk, evfa(lk,'oap',r));
    vfad(kl,'oap',r)   = evfa(kl,'oap',r)*vfa_up('oap',r);

    vfm_dn(targ,r)     = vfmd('land',targ,r)/ sum(lk, vfm(lk,targ ,r));
    vfmd(kl,targ,r)    = vfm(kl,targ ,r)*vfm_dn(targ,r);
    vfa_dn(targ,r)     = vfad('land',targ,r)/ sum(lk, evfa(lk,targ ,r));
    vfad(kl,'oap',r)   = evfa(kl,'oap',r)*vfa_dn('oap',r);

    vfm(kl,targ,r)      = vfm(kl,targ,r) - vfmd(kl,targ,r);
    vfm(kl,'oap',r)     = vfm(kl,'oap',r) + vfmd(kl,'oap',r);
    vfm('land',targ,r)  = vfm('land',targ,r) + vfmd('land',targ,r);
    vfm('land','oap',r) = 0;

    evfa(kl,targ,r)      = evfa(kl,targ,r) - vfad(kl,targ,r);
    evfa(kl,'oap',r)     = evfa(kl,'oap',r) + vfad(kl,'oap',r);
    evfa('land',targ,r)  = evfa('land',targ,r) + vfad('land',targ,r);
    evfa('land','oap',r) = 0;

  );

Parameters
  taxevoa
  rTF;

rTF(endw_comm0,'rTF',g,r)$vfm(endw_comm0,g,r) = evfa(endw_comm0,g,r)/vfm(endw_comm0,g,r);

taxevoa(endw_comm0,r)$(sum(g, vfm(endw_comm0,g,r) gt eps))
 = evoa(endw_comm0,r)/ sum(g, vfm(endw_comm0,g,r));

evoa(endw_comm0,r)       = taxevoa(endw_comm0,r) * sum(g, vfm(endw_comm0,g,r)) ;

execute_unload '%AggrName%VA_oap_adj.gdx'
VFM, EVFA, EVOA, OAPver
reg, prod_comm, endw_comm0
execute "gdx2har %AggrName%VA_oap_adj.gdx ../%AggrName%va_ir_rbaez_%oapv%/VA_oap_adj.har";

